# Decl2C.awk - Convert FG.xxxx DBE 0  to C source
# Mark Riordan  2006-02-24
BEGIN {
	comment_out_col = 32
}

function PeriodsToUnderscores(intext) {
	gsub(/\./, "_", intext)
	return intext	
}

function trim(inline) {
	if(" "==substr(inline, length(inline), 1)) {
		inline = substr(inline, 1, length(inline)-1)
	}
	return inline
}

{
	if("SPACE" == toupper($1)) {
	   print ""
		next;
	}
	if(trim($0)=="") {
		print ""
		next
	}
	line = $0
	comment = substr(line, 36)
	lower = tolower(line)
	bArray = 0
	if(substr(line,1,1)=="*") {
		out = "//" substr(line,3)
		print out
		next
	} if(lower ~ / d.e /) {
		mytype = "int";
		if(lower ~ / dwe/) {
			if(tolower(comment) ~ /addr/ || tolower(comment) ~ /pointer/) {
				mytype = "Byte8 *";
			}
		} else if(lower ~ / dse/) {
			mytype = "Byte8";
			bArray = 1;
			nEntries = toupper(PeriodsToUnderscores($3))
		}
		varname = tolower($1)
		gsub(/\./, "_", varname)
		out = "   " mytype " " varname 
		if(bArray) out = out "[" nEntries "]"
		out = out ";"
		print "   " varname " = 0;" >>"varinit"
	} else {
		out = " "
	}
	while(length(out) < comment_out_col) out = out " "
	out = out "// " comment
	print out
}