// ScrApp.h: interface for the CScrApp class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRAPP_H__B1C28F01_CCA9_4DF4_B170_560A37770699__INCLUDED_)
#define AFX_SCRAPP_H__B1C28F01_CCA9_4DF4_B170_560A37770699__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "TelnetC.h"
#include "resource.h"
#include "scrsyms.h"
#include "ScrSettings.h"

// Windows messages
#define WM_SCR_MSG (WM_USER+1)

typedef unsigned char Byte8;
typedef unsigned short Word16;
typedef unsigned long Word32;

#define CALL_SYSERR(msg) syserr(msg, __FILE__, __LINE__)

// SCREDIT symbolic constants
// Number of characters across the window (line length on screen).
#define SC_LNLEN 80

// Typedef describing the source of a character:
// received from mainframe vs. from keyboard.
typedef enum enum_char_source {
	SRC_MAINFRAME, SRC_KEYBOARD, SRC_MAX
} TypCharSource;

// Bytes 0-0xff are actual ANSI characters.
// Bytes >= OFFSET_FUNCKEY are virtual keystrokes (VK_xxx symbols)
//    with OFFSET_FUNCKEY added to them.
#define OFFSET_FUNCKEY 0x100

typedef enum enum_program_mode {
	MD_FREE, MD_TRM, MD_MSUE, MD_CMD, MD_STA=MD_CMD, MD_VT200, MD_HELP, MD_FT,
	MD_MAX
} TypProgMode;

// Function codes.  These are used in tables which drive scredit2
// based on a character, its source, and the current program mode.
// The names of the function codes are:
// FN_currentmode_source_description
// currentmode is TR for regular terminal mode
//                V2 for VT200 mode
//                ED for MSU EDITOR mode
//                CM for command mode
//                FT for file transfer mode
//                HL for help mode (Dunno that I'll implement this)
// source is R for received from mainframe
//           K for received from keyboard
// description is a description of what character is being handled, or what is done.

typedef enum enum_function_code {
	FN_NONE, 
   FN_TR_K_DEBUG, FN_TR_K_DEBUG2,
	FN_TR_R_CHAR, FN_TR_R_CR, FN_TR_R_LF, FN_TR_R_BS, FN_TR_R_TAB,
	FN_BEEP, FN_SETESC, FN_TOGGLE_INSERT,
	FN_TR_K_CHAR, FN_TR_K_CR, FN_TR_K_LFT, FN_TR_K_RIGHT,
	FN_TR_K_UP, FN_TR_K_DOWN, FN_TR_K_PAGEUP, FN_TR_K_PAGEDN, 
	FN_TR_K_DELCH, 
} TypFuncCode;

//typedef struct struct_key_entry {
	//TypProgMode    ke_mode;			// program mode (terminal vs. MSU EDITOR, etc.)
	//TypCharSource	ke_charsource;	// source of char (host or keyboard)
	//Word32			ke_keystroke;	// char or keystroke
	//TypFuncCode		ke_funccode;	// function code to invoke for this combo
//} TypCharMapping;

// TypFuncCodeMap maps from a mode/source/keycode combo to a function code.
// It's used to determine what routine to call to process a character.
// The integer key is constructed with a MAKE_KEY_xxx macro.
typedef std::map<unsigned int, TypFuncCode> TypFuncCodeMap;

// MAKE_KEY_FOR_KBD contructs an integer used as a key for TypFuncCodeMap,
// for chars that come from the keyboard.
// mode is the program mode to which this entry applies, an MD_xx symbol.
// bShift is 1 if this applies to when the Shift key is down (applied to keyboard only).
// bControl is 1 if this applies when the Control key is down.
// bAlt     is 1 if this applies when the Alt key is down.
// bIsFuncKey  is 1 if keyboard is a VK_xxx symbol, else keycode an an ANSI char.
// keycode     is the char to which this entry applies.
#define MAKE_KEY_FOR_KBD(mode, bShift, bControl, bAlt, bIsFuncKey, keycode) \
   (keycode | (bIsFuncKey<<8) | (bAlt<<9) | (bControl<<10) | (bShift<<11) \
   | (SRC_KEYBOARD<<12) | (mode<<16))

// MAKE_KEY_FOR_RCV contructs an integer used as a key for TypFuncCodeMap,
// for chars that come from the mainframe.
#define MAKE_KEY_FOR_RCV(mode, inbyte) \
   (inbyte | (SRC_MAINFRAME<<12) | (mode<<16))

class CScrApp  
{
protected:
	//int			m_nMappingEntries;
	TypFuncCodeMap m_mappings;
public:
	// Settings
	std::string m_strCmdLine;
	std::string m_strHost;
	int			m_Port;
	HWND			m_hwnd;
	BOOL			m_bConnected;
	BOOL			m_bSysErr;
	CScrSettings m_Settings;	// from scredit2.ini
   BOOL        m_bSendCmdsAtStartup;   // TRUE if we should send a canned set of cmds at startup.
	BOOL        m_bSendCRLF;	// TRUE to send CR LF at end of line instead of CR.
										//*** This does not work well with MS Telnet.

	std::string m_MacroCurrent;
	int			m_MacroCharsSent;

	// telnet handling
	CTelnetC		m_TelnetC;
	Byte8			m_inbuf_raw[2048];
	int			m_inbytes_raw;
	Byte8			m_inbuf[2048];
	int			m_n_inbytes;

	// display handling
	BOOL			m_bCursorOn;	// TRUE if we should draw the cursor.  This is toggled often, to cause blinking.
	COLORREF		refForeground;
	COLORREF		refBackground;
	COLORREF    refPenBorder;
	HFONT       m_hFontNormal;
	HPEN        m_penBorder;
	int			m_fontwidth;
	int			m_fontheight;
	int			m_MarginTop;
	int			m_MarginLeft;
	int			m_LinesOnScreen;
	int			m_CharsPerLine;
	int			m_PixelsInLine;

   // Screen
   Byte8       screen[SC_LNLEN*SC_PHSCN];  // Important buffer holding 80*24 screen image
   Byte8       *botline;   // address of bottom line (23 lines from top)
   Byte8       *msgl;      // address of message line (23 lines from top)
   Byte8       *statusl;   // address of status line (22 lines from top)
   Byte8       *debugl;    // address of debug line (21 lines from top)

   int         dp_chor;    // horizontal cursor position (0-based).
   int         dp_cvrt;    // vertical cursor position (0 = top line)

   // Textblocks
/*        STRUCTURE OF A TEXTBLOCK.
*         TEXTBLOCKS ARE EACH BLK.LENG BYTES LONG.
*         THE FIRST BLK.HEAD BYTES CONTAIN HEADER INFORMATION:
*         BYTES 1-2 ARE THE # OF ACTIVE BYTES IN THE BLOCK,
*                  INCLUDING THE HEADER AND THE 0#FF BYTE AT THE END.
*         THE REMAINDER OF THE ACTIVE PORTION OF THE BLOCK
*         CONSISTS OF CONSECUTIVE TEXTLINES IN MEMORY.
*/
   Byte8       *blocks;    // Big block of memory for all textblocks

	// current mode, etc.
	Byte8 		m_inchar;
   BOOL        m_bKeyHandled; // TRUE if keystroke was handled in WM_KEYDOWN

   Byte8 * bf_cmex;             // ADDR OF FWA OF EXTRA CHARS IN
//                                 COMMAND LINE BEYOND THOSE USED TO
//                                 parse the COMMAND.  CHARS ARE
//                                 TERMINATED BY 0.
   Byte8 * bf_stra;             // ADDR OF STRING OF CHARS THAT REMAIN
//                                 TO BE OUTPUT BY PUTSTR
   Byte8 bf_lnas[2*LN_LENNO+2]; // BUFFER FOR ASCII LINE #

#define bf_dpch bf_misc         // BUFFER FOR 'DUPLICATE CHAR' FEATURE
#define tb_rev  bf_misc         // LIST OF ADDRESSES ON SCREEN TO
//                                 REVERSE VIDEO (INSTALLED TO
//                                 FACILITATE TAKING PHOTOGRAPHS OF
//                                 THE ONTEL SCREEN).
//                                 (contains 2*ct.mxrev bytes)
   Byte8 bf_misc[LN_TXLEN+LN_HDLEN];// buffer for lots of miscellaneous
//                                     temporary usages (within a single
//                                     keystroke)
   int bf_kchr;                 // CONTAINS A CHAR FROM KEYBOARD
   Byte8 bf_cpyl[LN_TXLEN];     // BUFFER FOR THE 'COPY LINE' KEY

                                // 
   Byte8 bf_vid[CT_VICBE];      // BUFFER OF flags to indicate lines
//                                 to be displayed by ISRVRT.
//                                 if bf.vid[j] is <>0, then isrvrt
//                                 should display line j.  J starts
//                                 at 0 for the top line on screen.
                                // 

//        the following collection of variables is to be taken as
//        a unit:  together, they describe the bottom line in terminal
//        mode.
//        the first ln.hdlen bytes are of the same format as a packed
//        line header.
#pragma pack(push, 1)
#define botbuf ln_bttr
   Byte8 ln_bttr[LN_LENNO+1];   // line # of bottom line in term mode
                                // includes line length byte at end
   Byte8 ct_bfkc;                 // character ordinal of first char
//                                 on the line that is an echo of
//                                 a char typed at the keyboard.
//                                 0#ff means none.
//                                 invalid when cursor is on bot line.
   Byte8 ln_bttr_unused;
   Byte8 bf_inln[LN_TXLEN+3];   // BUFFER FOR INCOMING CHARACTERS IN
//                                 terminal mode.
                                // blank goes here
                                // and here
                                // zero to end buffer.
#pragma pack(pop)
   Byte8 pt_inln;               // next available position in bf.inln.  
                              // (place to put next char from mainframe.)

//        VARIABLES FOR LINE BEING BUILT FROM ASCII CHARS FROM MAINFRAME
//        the variables 'blb' through 'blb.buf' are in internal packed
//        format, and start with a line header.

//--- Start of BLB.
   Byte8 blb_lno[LN_LENNO];     // LINE # OF BUILT LINE
   Byte8 blb_len;                 // LENGTH OF LINE IN BUFFER
   Byte8 blb_fkc;                 // ordinal of first keyboard char
   Byte8 blb_unu;                 // UNUSED
   Byte8 blb_buf[LN_TXLEN];     // BUFFER OF ASCII CHARS (& DUPED CHARS)
//--- End of BLB.

   Byte8 blb_ctf;                 // CURRENT FRACTIONAL DIGIT BEING
//                                 entered.  110 BINARY=TENTHS,
//                                 111=HUNDREDTHS, ETc.
   int blb_got;                 // =TRUE IF WE SEEM TO HAVE RECEIVED A
//                                 LEGITIMATE LINE FROM THE MAINFRAME.
//                                 THIS FLAG IS CHECKED WHEN A CARRIAGE
//                                 RETURN IS RECEIVED, TO DECIDE WHETHER
//                                 TO ENTER THIS LINE IN A TEXTBLOCK.
//                                 THIS FLAG IS NEC. BECAUSE OF MSGS
//                                 FROM THE OPERATOR, ETC., WHICH COULD
//                                 COME UNEXPECTEDLY.
   int blb_okr;                 // =TRUE IF WE RECEIVED AN 'OK-'
   int blb_nch;                 // NUMBER OF TIMES LAST CHAR APPEARED.
   Byte8 blb_oln[LN_LENNO];     // LINE # OF PREVIOUS LINE

//        Structure of TEXTBLOCK INDEX:
//        For each textblock, and for each 'psuedo textblock'
//        (Indicating a discontinuity for MSU EDITOR mode)
//        (currently not implemented)
//        and for each textblock on a diskette in standalone
//        mode, (currently not implemented), there is an entry
//        in the textblock index.
//        Each entry is IDX.entr bytes long, and looks like this:
//
//        BYTES 1-6  BEG LINE # OF TEXTBLOCK
//        BYTE   7   textblock number of this block.
//                   block's fwa is 'blocks' + 1024*(this byte)
//        BYTE   8   # OF LINES IN THIS TEXTBLOCK
//        BYTE   9   ** DISK TRACK #, IF ANY ** /These will have disk /
//        BYTE  10   ** DISK BLOCK #, IF ANY ** /random block pointers/
//
//        The index enties for edit mode and terminal mode have
//        the same format, and share the same index buffer--'edindex'.
//        The first part of this buffer contains index entries for
//        edit mode (starting at 'edindex').
//        right after the last valid edit mode index entry is a dummy
//        entry with a first byte containing 'mk.inend'.
//        immediately after this entry start the entries for terminal
//        mode.  the first entry is pointed to by 'tridxpt'.
//        Whenever an entry is added to or deleted from the edit
//        mode's part of the index, the terminal mode index must
//        be moved and 'tridxpt' must be udpated.
//        this scheme allows us to save memory--if both modes didn't
//        share the same space, then we'd have to statically
//        allocate two tables of this size, one for each mode.
//
//        Within each part of the index, entries are stored in
//        ascending line number order.
//
   Byte8 *tridxpt;              // points to first term mode index entry
   Byte8 idxfwa1[IDX_ENTR];     // mk.inbeg should be placed here to
//                                 mark the beginning of the index.
   Byte8 edindex[IDX_ENTR*IDX_NENT];//  edit & term mode index
   Byte8 *idxlwa1;              // LWA+1 of entire textblock index.
//
   Byte8 * in_adin;             // ADDR OF ENTRY BEING ADDED IN ADDIDX
   Byte8 * in_mdbg;             // ADDR OF INDEX ENTRY FOR FIRST LINE
//                                 OF DEFINED BLOCK.
   Byte8 * in_mden;             // ADDR OF INDEX ENTRY FOR LAST LINE OF
//                                 DEFINED BLOCK.
//
   int idxattr;                 // This is a 4-bit index into
//                                 ATTARRY.  It is based on the
//                                 currently selected renditions.
//                                 It's used only for VT200 mode.
// ---------------------------------------------------------------------

// ---------------------------------------------------------------------

//        Miscellaneous vt200 mode variables.

   Byte8 * attrs;                   // fwa of attributes array for
//                                 vt200 mode.  This is an array
//                                 the same size as a screen.
//                                 Each byte corresponds to a character
//                                 on the screen, and indicates what
//                                 attribute (see att.* symbols)
//                                 it should have.

   Byte8 v2vals[CT_V2MAX];      // list of numeric values received
//                                 in current vt200 escape sequence,
//                                 one per byte.
//                                 -1 means this value was skipped
//                                    over (via ";") in esc sequence
//                                 ct.v2v has the number of active
//                                 entries in this list.
//        VARIABLES RELATED TO THE SCREEN AND LINES DISPLAYED ON IT
//        THESE VARIABLES HAVE VALUES RELATED ONLY TO THE ONTEL SCREEN
   Byte8 * sc_crla;             // ADDR OF PHYSICAL SCREEN LINE
//                                 BEING DISPLAYED
   Byte8 * sc_clba;             // ADDR OF PHYSICAL SCREEN LINE
//                                 THAT CORRESPONDS TO THE CLB
   Byte8 sc_tabs[SC_LNLEN+1];   // array of tab stops for vt200 mode.
//                                 0 at a column position means no tab.
//                                 1 means a tab is set there.
   int sc_attr;                 // current video attribute for vt200
//                                 mode.  (e.g., normal, reverse, etc.)
//                                 for ibm pc, one of the att.xxxx
//                                 symbols.
   int sc_v2tm;                 // top scrolling margin.  0 means the
//                                 top line, and that is the default.
   int sc_v2bm;                 // bottom scrolling margin.  Lines are
//                                 numbered from 0=top.  The default
//                                 (set in INIT) is the bottom line
//                                 of the screen.
//        Reserve space for File Control Block (FCB) tables and/or
//        file 'handle' and file name buffers for MS-DOS disk access.
//
//
   Byte8 bf_ftnm[L_FNMAX+1+1];    // Received copy of file transfer name
                                // Zero byte terminator //!
//
   Byte8 ftnamw[L_FNMAX+1+2];     // Working copy of file transfer name
                                // Zero byte terminator //!


//        VARIABLES RELATED TO THE SELECTION OF WHICH LINES IN THE
//        MAIN LINE BUFFER ARE TO BE DISPLAYED.
//        VALUES OF LINE LOCATIONS, FOR EXAMPLE, ARE 16-BIT ADDRESSES,
   Byte8 * ds_msga;             // ADDR OF MSG TO DISPLAY ON STATUS LINE

   int ds_nsln;                 // # OF SCREEN LINES AVAILABLE FOR LINES
   Byte8 * ds_crla;             // ADDR OF LINE CURRENTLY BEING
//                                 displayed.
   Byte8 * ds_crea;             // ADDR OF INDEX ENTRY FOR LINE BEING
//                                 displayed.
   Byte8 ds_tpln[LN_LENNO];     // LINE # OF TOP LINE in current MODE
   Byte8 ds_edtp[LN_LENNO];     // LINE # OF LINE AT TOP OF SCREEN
//                                 IN edit MODE.
   Byte8 * ds_trcl;             // fwa of actual screen line corresp.
//                                 to the clb in terminal mode.
   Byte8 * ds_stcm;             // fwa of line on screen of last cmnd
//                                 (baud, click, etc.) displayed in
//                                 'status' mode.
   Byte8 * ds_sttb;             // fwa of screen line to start display
//                                 of tab info in status mode
//        CURRENT LINE BUFFER VARIABLES
//        the variables clb.lno upto (but not including) clb.buf
//        are a correctly-formatted internal line header.
//        The ASSUMEs below help ensure this.

#pragma pack(push, 1)
   Byte8 clb_lno[LN_LENNO+1];     // LINE # FOR CURRENT LINE
                                // unused (line length)
   Byte8 clb_fkc;                 // character ordinal in clb of first
//                                 char on line that's echoed from
//                                 keyboard in terminal mode.
//                                 0#ff means no keyboard chars (this
//                                 is always the case for edit mode.)
   Byte8 clb_zero;               // always zero.
   Byte8 clb_buf[LN_TXLEN+3];     // BUFFER FOR CURRENT LINE
                                // blank
                                // blank
                                // zero to end buffer.
#pragma pack(pop)
   int clb_alt;                 // ALTERED FLAG
   int clb_scl;                 // SCREEN LINE # (0-23) OF CLB
   Byte8 clb_col;                 // COLUMN # CURSOR IS IN.
   int clb_cln;                 // (# OF LINES + 1) TO READ IN
//                                 BEFORE DECLARING A READ-IN LINE TO
//                                 BE THE CURRENT LINE.
   int clb_ecl;                 // edit mode copy of column # (when
//                                 edit mode is not active).
//        tab stops.

#pragma pack(push, 1)
   Byte8 tabset_zero;				// zero //!
                                // zeros bracket the tabsets.
   Byte8 tabset1[LN_TXLEN+2];     // tabset 1
                                // zeros bracket the tabsets.
                                // 
   Byte8 tabset2[LN_TXLEN+2];     // tabset 2
                                // zeros bracket the tabsets.
#pragma pack(pop)

//        VARIABLES RELATED TO THE STORAGE OF LINES IN THE MAIN BUFFER
//
//        STRUCTURE OF A TEXT LINE:
//        EACH LINE CONSISTS OF A LINE HEADER,
//        FOLLOWED BY COMPRESSED TEXT.
//        LINE HEADER:
//        BYTES 1-6  LINE # IN BCD (TWO NIBBLES PER BYTE)
//        BYTE   7   TOTAL # OF BYTES USED BY THIS LINE
//        byte   8   ordinal of the first char in this line that
//                   is echoed from the keyboard.  if none, value is ff.
//        BYTE   9   UNUSED--ZERO.
//        THE COMPRESSED TEXT CONSISTS OF NORMAL CONSECUTIVE ASCII
//        CHARACTERS, EXCEPT THAT N >= 2 CONSECUTIVE IDENTICAL CHARS
//        ARE REPLACED BY TWO BYTES:
//        128+CHAR, COUNT OF # OF TIMES THE CHAR APPEARED.

   Byte8 * ln_adno;             // ADDR OF LINE BEING ADDED
   Byte8 * ln_tbln;             // ADDR OF CURRENT LINE IN TEXTBLOCK
   int ln_sdif;                 // # OF BYTES TEXTBLOCK WILL HAVE TO BE
//                                 MOVED TO ACCOMODATE NEW LINE
   int ln_exst;                 // =TRUE IF LINE BEING ADDED ALREADY
//                                 exists.
   Byte8 * ln_fnbk;             // ADDR OF LINE BEING LOOKED AT
//                                 in 'findblk'.
   Byte8 * ln_fnln;             // ADDR OF LINE BEING SEARCHED FOR
//                                  IN FINDLN
   Byte8 * ln_fncr;             // ADDR OF LINE BEING COMPARED AGAINST
//                                 SEARCHED-FOR LINE
   Byte8 * ln_fnin;             // ADDR OF INDEX ENTRY FOR LINE BEING
//                                 SEARCHED FOR
   Byte8 ln_diff[LN_LENNO];     // DIFFERENCE BETWEEN LINE #'S.
   Byte8 ln_blbg[LN_LENNO];     // THE LINE # OF THE FIRST LINE IN A
//                                 BLOCK TO BE MOVED OR DUPED.
   Byte8 ln_blen[LN_LENNO];     // THE LINE # OF THE LAST LINE IN A
//                                 BLOCK TO BE MOVED OR DUPED.
   Byte8 ln_binc[LN_LENNO];     // LINE # INCREMENT (DECREMENT) TO BE
//                                 USED FOR NEW LINES BEING CREATED
//                                 AS A RESULT OF MOVE OR DUP
   Byte8 ln_mdol[LN_LENNO];     // LINE # OF LINE CURRENTLY BEING
//                                 MOVED/DUPED.
   Byte8 ln_mdnl[LN_LENNO];     // LINE # OF LINE TO MOVE/DUP NEXT.
   Byte8 ln_mdll[LN_LENNO];     // LINE # (PRIOR TO INCREMENT/DECREMENT)
//                                 OF FIRST LINE TO BE CREATED IN
//                                 MOVE/DUP PROCESS.
   Byte8 ln_edcl[LN_LENNO];     // line # of current line in edit mode.
//                                 (this # is updated when leaving edit
//                                 mode, and looked at when entering
//                                 edit mode.)
   Byte8 ln_old[LN_LENNO];      // general purpose old line # (used
//                                 in delln).
   Byte8 ln_pgbt[LN_LENNO];     // line # of last acceptable top line
//                                 in trkpgfr
   int ln_stab;                 // screen line ordinal of line that has
//                                 tab stops on it in status mode.
//        VARIABLES THAT CONTAIN ADDRESSES.

   Byte8 * ad_ccmd;             // ADDR OF CURRENT ENTRY IN CMD TABLE
   int ad_tbcr;                 // fwa of current tabset entry
   int ad_tbal;                 // fwa of alternate tabset entry


	// Not all of these variables are used.

   unsigned char fg_insr;       // 0=REPLACE MODE, 1=INSERT MODE
   unsigned char fg_mful;       // 0=OK TO SEND CHARS TO MAINFRAME
                                // 1=SEND CHARS ONLY TO NEXT CR
                                // 2=DO NOT SEND CHARS TO MAINFRAME
   unsigned char fg_tful;       // 1='TERMINAL FULL', ELSE 0
   unsigned char fg_hlti;       // 1='NEED TO SEND DC3', ELSE 0
   unsigned char fg_srti;       // 1='NEED TO SEND DC1', ELSE 0
   unsigned char fg_bsci;       // 1='BSC IN USE', ELSE 0
   TypProgMode fg_mode;       // CURRENT PROGRAM MODE:
                                // MD.FREE  = NO MODE,
                                // MD.TRM   = TERMINAL MODE
                                // MD.MSUE  = MSU EDITOR MODE
                                // MD.CMD   = COMMAND MODE
                                // MD.STA   = STATUS MODE
                                // MD.HLP   = HELP MODE
                                // MD.FT    = FILE TRANSFER MODE
                                // md.vt200 = vt200 mode
                                // 
   TypProgMode fg_modo;       // OLD PROGRAM MODE, STORED FOR FUTURE
                                // use, usually in edit mode.
   unsigned char fg_ccmd;       // the command ordinal of the current
                                // command.  (0 if the characters being
                                // entered by the user in command mode
                                // do not yet specify a unique command.)
   unsigned char fg_rlin;       // TRUE=RECEIVING LINES FROM MAINFRAME
   unsigned char fg_clik;       // TRUE=CLICK FOR EVERY KEYBOARD HIT
   unsigned char fg_lkls;       // =TRUE MEANS PCKINLN SHOULD FIGURE OUT
                                // WHETHER LAST LINE IN EWFILE IS BEING
                                // RECEIVED.
   unsigned char fg_glst;       // =TRUE MEANS THE LAST LINE IN THE
                                // EWFILE IS IN MEMORY
   unsigned char fg_lnex;       // TRUE=THERE'S AT LEAST 1 LINE IN
                                // textblock memory.
   unsigned char fg_buch;       // TRUE=WE HAVE TYPED CHARS ON BOT LINE
   unsigned char fg_cken;       // FLAG FOR WHETHER WE'RE COUNTING
                                // LINES AS THEY COME IN, TO SEE IF WE
                                // ARE AT THE BEGINNING OR END OF THE
                                // EWFILE.
                                // 0 = NOT CHECKING,
                                // -1 = CHECKING FOR BEGINNING
                                // 1 = CHECKING FOR END
   unsigned char fg_ck1l;       // =TRUE MEANS THE CHECK FOR BOI OR EOI
                                // IS WHETHER THE LAST LINE RECEIVED
                                // IS ONE ALREADY IN A TEXT BLOCK.
                                // =FALSE MEANS A LINE COUNT IS USED
                                // INSTEAD.
   unsigned char fg_gfrs;       // =TRUE MEANS THE FIRST LINE IN THE
                                // EWFILE IS IN A TEXTBLOCK
   unsigned char fg_tdsb;       // ONTEL DISPLAY STATUS BYTE FOR
                                // TERMINAL MODE.
   unsigned char fg_mdsb;       // ONTEL DISPLAY STATUS BYTE FOR
                                // MSU EDITOR MODE.
   unsigned char fg_sdsb;       // ONTEL DISPLAY STATUS BYTE FOR
                                // status mode.
   unsigned char fg_ktim;       // =TRUE EVERY few minutes.  AT THESE
                                // INTERVALS, VARIOUS TIME-DEPENDENT
                                // OPERATIONS ARE PERFORMED & THE
                                // FLAG IS CLEARED.
   unsigned char fg_kchr;       // =0F H IF A CHAR IS PENDING FROM
                                // KEYBOARD, ELSE ZERO.
   unsigned char fg_stay;       // =TRUE MEANS WHEN CR IS HIT IN TERM
                                // MODE, CURSOR DOES NOT RETURN TO
                                // BASE LINE.
   unsigned char fg_edit;       // =0 IF 'EDIT' COMMAND NOT ACTIVE
                                // =1 IF WE'RE RECEIVING LINES AS A
                                //    RESULT OF THE 'EDIT' COMMAND.
                                // =2 IF WE GOT NO LINES BACK FROM THE
                                //    EDIT COMMAND WHEN FG.EDIT=1 &
                                //    WE HAD TO DO ANOTHER LIST TO SEE
                                //    IF THERE WAS ANYTHING IN THE
                                //    EWFILE. IF WE GET NO LINES WHEN
                                //    FG.EDIT=2, THE EWFILE'S EMPTY.
   unsigned char fg_bldf;       // DEFINED BLOCK STATUS WORD.
                                // BITS 7-2 ALWAYS CLEAR.
                                // BIT 1 IS ON IF THE FIRST LINE OF A
                                //   'MOVE' OR 'DUP' BLOCK IS DEFINED.
                                // BIT 0 IS ON IF THE LAST LINE OF
                                //   SUCH A BLOCK IS DEFINED.
   unsigned char fg_mddr;       // SPECIFIES RELATIVE LOCATION OF
                                // DEFINED BLOCK & DEST IN MOVE/DUP.
                                // 0=DEST COMES FIRST (MOVE BACKWARD)
                                // 1=BLOCK COMES FIRST (MOVE FORWARD)
   unsigned char fg_mdmd;       // =0 MEANS COMMAND IS MOVE
                                // =1 MEANS COMMAND IS DUP
                                // (ASSUMING IT'S EITHER MOVE OR DUP)
   unsigned char fg_upcs;       // =TRUE MEANS LOWER CASE ALPHAS FROM
                                // KEYBOARD SHOULD BE MADE UPPER.
   unsigned char fg_wrdp;       // =TRUE MEANS WE'RE IN 'WORD
                                // PROCESSING' MODE.
   unsigned char fg_keyp;       // =TRUE MEANS WE'RE IN KEYPUNCH-STYLE
                                // KEYBOARD MODE. (E.G., SHIFT M = 7)
   unsigned char fg_esc;        // =true means the characters coming
                                // from the mainframe are part of an
                                // escape sequence (that started,
                                // by definition, with an 'escape').
   unsigned char fg_dll;        // =true means there is a downline
                                // load in progress.
   unsigned char fg_nomm;       // =true means user can't get into
                                // msu editor mode except via escape
                                // sequence from mainframe.
                                // set via esc-soh-cap c.
   unsigned char fg_clmb;       // =true means msu editor mode buffer
                                // should be cleared whenever user
                                // leaves msu mode.
                                // when true, this flag bypasses the
                                // MENU--CAUSES the prog key to toggle
                                // between m and x modes.
                                // set via esc-soh-cap a.
   unsigned char fg_smen;       // =true means 'menu.' is sent to the
                                // mainframe whenever we enter terminal
                                // mode.
                                // set via esc-soh-cap b.
   unsigned char fg_rkey;       // =0#0f MEANS THAT CHARACTERS ARRIVING
                                // from the mainframe are treated as if
                                // they were being typed at the keyboard
                                // SET VIA ESC-eot.
   unsigned char fg_cobl;       // =true means cursor is on bottom line
                                // in terminal mode.
   unsigned char fg_stat;       // status mode flag:
                                // 0 (MK.STBCM) MEANS IN command MODE,
                                //   with cursor at beg of cmd line.
                                // 2 (mk.stcip) means in status mode,
                                //   during the typing or execution of
                                //   a command.
                                // 3 (mk.sttab) means in status mode,
                                //   WITH THE CURSOR ON THE tab LINE.
   unsigned char fg_stmd;       // <>0 iff we are in status mode and got
                                // there via statbeg.
   unsigned char fg_ltsc;       // =true means that there is less than
                                // an entire screen's worth of lines
                                // to display in terminal mode.
   unsigned char fg_blos;       // =true means that the bottom line in
                                // terminal mode is displayable on the
                                // screen.  (we haven't moved the screen
                                // from its base position.)
   unsigned char fg_fdb;        // =true means that ds1line should use
                                // the ontel's 'fast display blanking'
                                // mechanism (by putting a logical
                                // end-of-line char on the screen).
   unsigned char fg_rdy;        // =true means that a 'ready' is being
                                // displayed on the bottom line in
                                // status or edit mode, so the line
                                // should not be stored in a textblock
                                // (it would just be a waste of term
                                // mode textblock memory.)
   unsigned char fg_ndry;       // =true means we need to receive a
                                // 'ready' before we can begin to
                                // process ok's from the mainframe.
                                // initmsu puts out a 'ready', and
                                // pckinln makes sure that it receives
                                // the resultant 'ready' output before
                                // it starts worrying about ok's coming
                                // down & claiming that a 'list' has
                                // yielded no lines.
   unsigned char fg_mans;       // =true means that output has been
                                // halted manually by the user.
                                // this means that we shouldn't auto-
                                // matically send a dc1 to start
                                // things up until the user
                                // explicitly asks for it.
   unsigned char fg_cewc;       // =true means that we are checking
                                // to make sure that the current
                                // textblocks accurately reflect the
                                // actual ewfile.  the next line coming
                                // from the mainframe will be checked
                                // against textblock memory.
   unsigned char fg_dndb;       // =true means do not display the
                                // *** beginning of workfile *** msg
                                // in edit mode, even if all other
                                // conditions for the display of this
                                // line are met.  this allows for the
                                // situation in which the cursor is on
                                // the 22nd line of the file.  (the
                                // bottom line of edit mode.)
   unsigned char fg_bwms;       // =true means that the last time the
                                // screen was displayed in edit mode,
                                // a *** beginning of workfile ***
                                // line was displayed.  this variable
                                // is used to determine whether the
                                // top-of-screen pointer should be
                                // advanced when doing a cursor-down
                                // when on the bottom line of the screen
   unsigned char fg_dnds;       // =1 means 'do not display screen':
                                //   we are currently holding off on
                                //   displaying the screen because
                                //   we're behind on processing chars
                                //   arriving from the mainframe,
                                //   but we can start again as soon
                                //   as we catch up.
                                // =2 means do not display the screen
                                //   at all (until the flag changes
                                //   its value).
   unsigned char fg_abow;       // =true means 'at beginning of workfle'
                                // in edit mode--means the cursor is
                                // on the *** bow *** line.
   unsigned char fg_nobd;       // =0 means the 'baud' command is ok;
                                // else ignore the 'baud' command.
   unsigned char fg_usbl;       // =0 means use the 'fast dynamic
                                // blanking' feature in terminal mode;
                                // else pad out lines with blanks.
   unsigned char fg_init;       // =true means SCREDIT has finished
                                // initialization, else we are
                                // initializing.
   unsigned char fg_ver;        // =true means we are in VERIFY mode,
                                // else VERIFY is off.
   unsigned char fg_dbug;       // master debug flag.  0=debug is off.
                                // value of flag is number of lines near
                                // bottom of screen (just above the
                                // status line) that are being reserved
                                // for display of debug information.
                                // see assembly option "DEBUG" in
                                // SCRTEXT for more relevant info.
   unsigned char fg_dfpb;       // =true if the characters being
                                // received from the mainframe should
                                // be stuffed into the prompt buffer.
   unsigned char fg_tcfp;       // =true if we are taking characters
                                // from the prompt buffer.
   unsigned char fg_oeow;       // =true means that the cursor is on
                                // the *** end of workfile *** line.
                                // All the user can do is move the
                                // cursor up.  (The cursor got there
                                // by deleting the last line of file.)
   unsigned char fg_crlc;       // =1 means hitting carriage return
                                // in edit mode will not create a new
                                // line (just go to beg of next line).
                                // 
                                // 
   unsigned char fg_olhm;       // contains the program mode that was
                                // ACTIVE BEFORE HELP OR FT MODES WERE
                                // activated.
                                // 
   unsigned char fg_newv;       // NON-ZERO IF RECEIVING NEW SCREDIT
   unsigned char fg_ftfl;       // =TRUE if an FT file is OPEN
   unsigned char fg_soh;        // =TRUE IF SOH RECEIVED IN FT MODE
   unsigned char fg_stx;        // =TRUE IF STX RECEIVED IN FT MODE
   unsigned char fg_dle;        // =TRUE IF AS.DLE LAST CHR, FT RECEIVE
   unsigned char fg_end;        // =TRUE IF TERMINATE SCREDIT CODE RCVD
   unsigned char fg_ftmd;       // =FILE TRANSFER MODE - FT.SEND/FT.RECV
   unsigned char fg_ftb1;       // =TRUE if sending first byte of file
   unsigned char fg_tail;       // =TRUE IF DOING TRAILER OF FT SEND
                                // 
   unsigned char fg_ftcn;       // =TRUE IF CONDITIONAL FILE TRANSFER
   unsigned char fg_ftrn;       // =TRUE IF READ NAME FOR FILE TRANSFER
                                // 
                                // 
	//              These flags are used in decoding the data in a file
	//              transfer RECEIVE according to the SCREDIT protocol.
	//              They indicate things to do to the next data byte.
                                // 
   unsigned char fg_ftc6;       // Flag set to 40h to toggle bit 6
   unsigned char fg_fts7;       // Flag set to 80h to set bit 7
   unsigned char fg_ftml;       // =TRUE if multiple byte count sent
   unsigned char fg_sens;       // Holds ESCAPE flag sense modifiers
                                // while processing each flag.
   unsigned char fg_frpm;       // flag for 'host requested pause'
                                // msg in file transfer mode.  values:
                                // <0 means clear message
                                // 0  means do nothing
                                // >0 means display message.
   unsigned char fg_fspm;       // flag for 'scredit requested pause'
                                // msg in file transfer mode.  values:
                                // <0 means clear message.
                                // 0  means do nothing.
                                // >0 means display message.
                                // 
   unsigned char iirbyte;       // Holds the value KYFREE finds in the
                                // Interrupt Identification Register
   unsigned char fg_com1;       // TRUE when com-1 was initialized
   unsigned char fg_com2;       // TRUE when com-2 was initialized
   unsigned char fg_brk;        // TRUE when we are doing a com BREAK
   unsigned char fg_mdst;       // while in status mode, this is the
                                // mode we were in when the user hit
                                // the "enter status mode" key and
                                // hence is the mode we must return
                                // to when the user hits "exit status".
   unsigned char fg_fse;        // vt200 submode.
                                // =v.vtvt2 means pure vt200 emulation
                                // =v.vtfse means corruption of vt200
                                //          to assist cyber "FSE".
   unsigned char fg_v2ec;       // true iff receiving escape sequence
                                // in vt200 mode.
   unsigned char fg_v2nl;       // <>0 for cr means 'newline,' else cr
                                // means enter for IBM CMS.
   unsigned char fg_v2q;        // =true iff we have found that the
                                // current escape sequence is of the
                                // form esc [ ? (as opposed to no ?).
   unsigned char fg_v2ca;       // =true iff the cursor pad is in the
                                // inexplicable "application mode".
                                // (This alters the codes sent by
                                // the four arrow keys.)  DEC alone
                                // knows why such a thing exists.
   unsigned char fg_v2hl;       // =md.v2hxx, signifying which
                                // help screen is to be displayed
                                // in help mode for vt200 mode.
   unsigned char fg_v2in;       // <>0 if in insert mode on the vt200
                                // screen.
   unsigned char fg_nkap;       // =0 if the numeric keypad is in
                                // numeric mode,
                                // else =1 if numeric keypad is in
                                // application mode.
                                // Note:  this flag is examined only
                                // on the ontel, because the ibmpc
                                // has a strange keyboard layout that
                                // is not conducive to implementation
                                // of this dec mode.
   unsigned char fg_v2g;        // The character set currently in use
                                // in VT200 mode.
                                // 0=G0; 1=G1.
                                // Initially, both G0 and G1 are ASCII.
                                // See GCHAR in V2RPRN.
   unsigned char fg_scst;       // Used only in V2PREC.  Indicates
                                // whether the current character set
                                // setting escape sequence is setting
                                // G0 (0) or G1 (1).
                                // This is for sequences like
                                // esc ( B   or   esc ) 0  .
   unsigned char fg_dcaw;       // DEC Autowrap mode flag.
                                // TRUE=on, FALSE=off.
                                // When the flag is on, characters
                                // received when the cursor is at the
                                // last column of the screen wrap to
                                // the beginning of the next line.
                                // When it's off, characters overwrite
                                // existing characters at the right
                                // edge of the screen.

//        Scratch variables--used when the number of registers is
//        insufficient for the calculations at hand.

   Byte8 * ss_caad;             // ADDR OF CURRENT ABBR CHAR in
//                                 command processing.
   int ss_chct;                 // # OF USER-TYPED CHARS LOOKED AT
   Byte8 ss_savm[CT_MSGST+1];   // PLACE TO STORE STATUS LINE MESSAGE
   Byte8 * ss_2clb;             // CLB ADDR USED IN INT2CLB
   int ss_dslp;                 // COPY OF INTERNAL LINE PTR I DSSCRN
   int ss_sclb;                 // SCREEN LINE # OF LINE BEING DISPLAYED
   Byte8 * ss_asc2;             // ADDR OF STRING TO CONVERT IN ASC2LNO
   Byte8 * ss_2lno;             // ADDR OF WHERE TO PUT LINE # /ASC2LNO
   int ss_2frc;                 // FRACTION SUBSCRIPT FOR ASC2LNO
   int ss_nllp;                 // # OF LINES LEFT ON PAGE (SORTA)
   Byte8 ss_numb[4];            // STORAGE FOR DECIMAL CONVERSION
   int ss_cscl;                 // # OF LINES CLB IS FROM TOP OF SCREEN
   Byte8 * ss_crin;             // CURRENT LINE INDEX POINTER
   Byte8 * ss_crbk;             // CURRENT LINE POINTER IN THIS BLOCK
   int ss_nllq;                 // CURRENT LINE'S DISTANCE FROM TOP OF
//                                 screen.
   int ss_pgnc;                 // =TRUE IF, IN PGFRWD, WE HAVEN'T
//                                 FOUND THE NEW CURRENT LINE YET.
   Byte8 * ss_mdin;             // INDEX POINTER FOR CURRENT LINE BEING
//                                 MOVED/DUPED
   Byte8 * ss_mdbk;             // LINE-WITHIN-BLOCK POINTER OF CURRENT
//                                 LINE BEING MOVED/DUPED.
   Byte8 ss_diff[LN_LENNO];     // SCRATCH DIFFERENCE BETWEEN LINE #'S.
   int ss_spmd;                 // mode of textblock being split
//                                 used in 'split', not surprisingly.
   int ss_dsnl;                 // # of lines left to display in dstrsc
   int ss_bkln;                 // # OF LINES LEFT TO SKIP BACKWARDS
//                                 in trbotm.
   int ss_adlm;                 // mode of line to be added in 'addln'.
   Byte8 * ss_pgcl;             // line addr of potential clb in trkpgfr
   Byte8 * ss_pgci;             // index addr of above
   Byte8 * ss_pgtl;             // line addr of potential top line in
//                                 trkpgfr
   Byte8 * ss_pgti;             // index addr of above
   int ss_pgct;                 // count of # of lines left to skip in
//                                 trkpgfr
   int ss_tenn;                 // number 10-140 used in dstabrl to
//                                 create tab ruler.

   //--- Variables containing counts -----------------------

   int           ct_cmch;       // # OF COMMAND CHARS ACTUALLY TYPED IN
   int           ct_rtln;       // (# OF LINES + 1) TO READ IN
                                // BEFORE MAKING THE READ-IN LINE THE TO
                                // LINE ON THE SCREEN.
   int           ct_cken;       // -(NUMBER OF LINES WE EXPECT TO
                                // RECEIVE FROM MOST RECENT LIST)
   int           ct_okln;       // # OF LINES WE'VE SENT SINCE
                                // SENDING 'OK'.
   int           ct_okmx;       // # OF LINES TO OUTPUT BEFORE
                                // SENDING 'OK'.
   int           ct_blok;       // NUMBER OF LINES IN THE CURRENTLY
                                // DEFINED BLOCK.
   int           ct_dlld;       // # of data bytes left to process
                                // in this record in a downline load.
   int           ct_rev;        // # of characters on screen to reverse
                                // video for the 'reverse video' key
   int           ct_bked;       // # of textblocks currently allocated
                                // to edit mode.
   int           ct_bktr;       // # of textblocks currently allocated
                                // to terminal mode.
   int           ct_trmn;       // minimum # of textblocks that can be
                                // allocated to terminal mode.
   int           ct_trmx;       // maximum # of textblocks that can be
                                // allocated to terminal mode.
                                // 
   int           ct_cstm;       // # of chars sent to mainframe from
                                // keyboard and not yet echoed.
   int           ct_trln;       // # of lines in memory for terminal
                                // mode (shld format)
   int           ct_edln;       // # of lines in memory for edit mode
                                // (shld format)
                                // 
   int           ct_ftdp;       // Dup count during file transfer
                                // Points to last byte filled when a
                                // disk read is less than requested amt
                                // Total bytes transfered for FT mode
                                // Check sum for File Transfer mode
   unsigned char ft_pvch;       // Previous character saved for dup
                                // character handling in file transfers
                                // 
   int           ct_debs;       // # of destructive backspaces pending
                                // in terminal mode (on bottom line).
                                // # of characters in the prompt
                                // buffer.  if equal to zero, then
                                // no prompt buffer is defined.
                                // character number of the next
                                // character to be taken from the
                                // prompt buffer.
   int           ct_mxnd;       // maximum number of lines that we
                                // can suppress displaying before
                                // we have to display the Terminal
                                // mode screen, even if we are
                                // behind in processing characters.
                                // Provided as an ergonomic feature.
   int           ct_nlnd;       // Number of lines that we have
                                // suppressed so far in T mode, in
                                // an attempt to catch up in processing
                                // characters that are arriving.
                                // If FG.DNDS is FALSE, this count
                                // is still maintained but has no
                                // meaning.
   int           ct_lf;         // This is the the negative of the
                                // number of line feeds
                                // that we expect to have echoed as
                                // a result of commands that we have
                                // sent to the mainframe.  This count
                                // is incremented when we actually
                                // get the line feeds.  The count is
                                // used to keep track of flow control.
                                // 
   int           ct_wtlf;       // number of timer ticks until we
                                // should clear ct.lf.  this is put
                                // in as a safety valve, in case
                                // something goes wrong with ct.lf.
                                // we don't want scredit to hang.
                                // (note:  i was going to put this
                                // in initially, then got lazy.
                                // now it appears that it was a good
                                // idea.)
   int           ct_lldv;       // ordinal of last line looked at by
                                // the last invocation of isrvrt.
                                // we start updating lines at the next
                                // line after this, so that the same
                                // lines on the screen don't get updated
                                // time after time, with the other
                                // lines ignored for long whiles by
                                // isrvrt.
   int           ct_tick;       // byte that is constantly incremented
                                // by isrvrt, every vertical retrace.
                                // used to time breaks, and possibly
                                // for other purposes in the future.
   int           ct_v2v;        // count of numeric values received in
                                // latest escape sequence in vt200 mode.
                                // These are kept in v2vals.

//       MISCELLANEOUS VARIABLES

   int clock;                   // TIME IN SECONDS FROM BEG OF PROGRAM
   Byte8 nowchar;                 // If non-zero, the character that
//                                 should next be sent to the host.
//                                 this is a quick, one-character
//                                 way of bypassing the circular buffer.
   Byte8 chars[8];              // list of chars for misc. purposes.
//                                 used esp. for passing parameters to
//                                 'srchchr'.
   Byte8 * dllad;               // address to load the next byte at
//                                 in a downline load.
   int dlltype;                 // the record type of the current
//                                 record in a downline load.
   int lmargin;                 // LEFT MARGIN FOR MSU MODE. BASE=0.
   int trlmarg;                 // left margin for terminal mode.
//                                 0=display starting with first char.
   int tabmarg;                 // left margin for tab display in status

//        VARIABLES RELATED TO TEXTBLOCKS
                                // 
   int bk_scnm;                 // # OF TEXTBLOCK CURRENTLY BEING SPLIT
   Byte8 * bk_scba;             // ADDR OF TEXTBLOCK BEING SPLIT
   Byte8 * bk_scbi;             // ADDR OF INDEX ENTRY BLOCK BEING SPLIT
   Byte8 * bk_spta;             // ADDR OF BLOCK SPLIT POINT
   int bk_slnn;                 // # OF LINES IN 1ST HALF OF SPLIT BLOCK
   int bk_snnb;                 // # OF BYTES TO COPY TO NEW BLOCK/SPLIt
   int bk_snnl;                 // # OF LINES IN NEW PART OF SPLIT BLOCK
   Byte8 * bk_adin;             // ADDR OF INDEX ENTRY FOR LINE ADDED
   Byte8 * bk_aidx;             // ADDR OF INDEX ENTRY BEING ADDED
//                                 in 'addblk'
   int bk_ntxt;                 // # OF TEXTBLOCKS. DEPENDS ON RAM SIZE.
   Byte8 * bk_snin;             // ADDR OF INDEX ENTRY OF NEW BLOCK
//                                 used in 'split'.
   Byte8 * bk_adbg;             // ADDR OF BEG OF BLOCK BEING ADDED TO.
   TypProgMode bk_uset[BLK_NUMB]; // textblock usage table.
//                                 this is a table indexed by textblock
//                                 number.  each entry contains 0 if
//                                 the corresponding textblock is free,
//                                 else md.xxx, indicating which program
//                                 mode currently owns that textblock.
//                                 (textblocks are numbered starting
//                                 at 0, and for a 16k ram machine,
//                                 these numbers would go to about 10.)
   Byte8 bk_nfre[4];             // list of block #'s that 'freeblk'
//                                 should not allocate when asked
//                                 for a free block.
//                                 list is terminated by a byte
//                                 containing 'mk.endls'.
   int bk_pmbf;                 // textblock number of prompt buffer.
   int bk_pbad;                 // address of prompt buffer textblock.
   Byte8 bf_del[LN_TXLEN];      // COPY OF LAST DELETED LINE



public:
   static BOOL CALLBACK DlgProcConnect(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

	LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	CScrApp();
	void Initialize();
	virtual ~CScrApp();
   void syserr(const char *msg, const char *file, int linenum);
	void varinit();
   void EnterMappingHost(TypProgMode mode, Byte8 inchar, TypFuncCode funccode) {
      int key = MAKE_KEY_FOR_RCV(mode, inchar);
		m_mappings[key] = funccode;
	}
   void EnterMappingKybd(TypProgMode mode, BOOL bShift, BOOL bControl, BOOL bAlt, 
      BOOL bIsFuncKey, Byte8 inchar, TypFuncCode funccode) {
      int key = MAKE_KEY_FOR_KBD(mode, bShift, bControl, bAlt, bIsFuncKey, inchar);
      m_mappings[key] = funccode;
   }
	void InitializeMappings();

   void inittrm();
   void trbotm();
   void fill(Byte8 *dest, int nbytes, Byte8 mybyte);
   Byte8 AddBCD(Byte8 bcd1, Byte8 bcd2, Byte8 &carry);
   void addlno(Byte8 *linenum1, Byte8 *linenum2, Byte8 *result);
   void blnkscr();

   void init();
   Byte8 *bkn2adr(unsigned int blocknum);
   Byte8 *blkadr(Byte8 *pIdxEnt);
   BOOL freeblk(TypProgMode mode, int &TextblockNum);
   void clb2int(Byte8 *inbytes);
   void clb2ibf();
   BOOL nxtidx(Byte8 *&pidxent);
   BOOL prvidx(Byte8 *&pidxent);
   BOOL findln(Byte8 *linenum, TypProgMode mode, Byte8 *&pBlkIndexEntry, Byte8 * &pLineInBlock);
   BOOL findlcm(Byte8 *linenum, Byte8 *&pBlkIndexEntry, Byte8 * &pLineInBlock);
   void findtsc(Byte8 *&pBlkIndexEntry, Byte8 * &pLineInBlock);
   int cntln(Byte8 *pBlkIndexEntry);
   void bookln();
   Byte8 *begidx(TypProgMode mode);
   BOOL findblk(Byte8 *linenum, TypProgMode mode, Byte8 *&pBlkIndexEntry);
   Byte8 *addblk(Byte8 * pFirstLineNum, TypProgMode mode);
   void delblk(Word32 TextBlockNum);
   BOOL dellnb(Byte8 *linenum, TypProgMode mode);
   void splittr(Byte8 *pBlkIndexEntry, TypProgMode mode);
   void split(Byte8 *pBlkIndexEntry, TypProgMode mode);
   void addln(Byte8 *packed_line, TypProgMode mode);
   void addlncm(Byte8 *packed_line);
   void newibf();
   void addibf();
   void addlbtm();
   void addclb();
   BOOL prvlnb(Byte8* &pBlkIndexEntry, Byte8 *&pLineInBlock);
   BOOL nxtlnb(Byte8* &pBlkIndexEntry, Byte8 *&pLineInBlock);
   BOOL nearln(Byte8* LineNumToFind, TypProgMode mode, Byte8* &pidx, Byte8 *&pLineInBlock);

   void ibf2clb();
   void int2clb(Byte8 *pLineInBlock);
	BOOL modlm(int *pLeftMargin, Byte8 cursorPos);
   void chklm();
	BOOL checke();

   void dstrclb();
	void dsclb();
   void dstrsc();
   void dsscrn();
   void dstribf();
   void ds1line(Byte8 *pLineInBlock, Byte8 *pScreenLn, int nbytes, int lmargin);
	void litekey();

	void ProcByteFromHost(Byte8 inbyte);
	void do_nothing() { }
	void escape();
	void v2prec();
   Byte8 getcrch(Byte8 *&pCurChar);
   BOOL incebf(Byte8 *pCursorPos);
   void chinclb(Byte8 inchar);
	void endrec();

   void cursrup();
   void cursrdn();
   void trkcudn();
	void tbarriv();
	void kydelch();
	void kyinsrt();

	void trrchar();
	void trrtab();
   void trrcr();
   void trrlf();
	void trrbs();

   void kyprint(Byte8 inbyte);

   void trklft();
	void trkrgt();
   void trkchar();
   void trkcr();
   void trkpgbk();
   void trkpgfr();

   void putasy(Byte8 inbyte);
	void sendchs(Byte8 *buf, int nchars);

   void DebugDump(const char *msg);

	void CallFuncForCode(TypFuncCode fncode);
   BOOL CallFuncForMapKey(int key);
   BOOL CallFuncForRcvChar(Byte8 inchar);
   BOOL CallFuncForKybdChar(BOOL bShift, BOOL bControl, BOOL bAlt, 
     BOOL bIsFuncKey, Byte8 inchar);

	void CauseRepaint() {
		InvalidateRect(m_hwnd, NULL, FALSE);
	}
	BOOL IsConnected() {
		return m_bConnected;
	}
	BOOL StartConnect();
   void Disconnect();

	void ProcessMacroChunk(HWND hWnd);

	LRESULT OnCreate(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT OnSockMsg(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT OnSize(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT OnPaint(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
   LRESULT OnKeyDown(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
   LRESULT OnChar(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
   LRESULT OnTimer(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
   LRESULT OnCommand(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	void SetCmdLine(const char *pszCmdLine) {
		m_strCmdLine = pszCmdLine;
	}
};

#endif // !defined(AFX_SCRAPP_H__B1C28F01_CCA9_4DF4_B170_560A37770699__INCLUDED_)
