// ScrSettings.cpp: implementation of the CScrSettings class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ScrSettings.h"
#include "ScrUtil.h"
#include "scrsyms.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CScrSettings::CScrSettings()
{
	m_strFontFace = "Lucida Console";
	m_FontSizeInPoints = 12;
	m_nTextblocks = BLK_NUMB;
}

CScrSettings::~CScrSettings()
{

}

/*--- function GetINIFilename --------------------------
 *  Exit:	Returns the name of the initialization file.  This file might not exist.
 *				The returned string is empty if an error occurs in looking it up.
 */
std::string CScrSettings::GetINIFilename()
{
	std::string strFilename;
	char szFolder[MAX_PATH];
	if(S_OK == SHGetFolderPath(NULL,CSIDL_APPDATA,NULL,SHGFP_TYPE_CURRENT,szFolder)) {
		strFilename = szFolder;
		strFilename += "\\scredit2.ini";
	}
	return strFilename;
}

BOOL CScrSettings::CrackConnString(std::string strName, std::string strValue, TypConnSetting &conn)
{
	BOOL bOK = FALSE;
	std::string strHost, strPort;
	if(CScrUtil::ParseArg(strValue.c_str(), '|', strHost, strPort)) {
		conn.conn_host = strHost;
		conn.conn_port = atoi(strPort.c_str());
		bOK = TRUE;
	}
	return bOK;
}

std::string CScrSettings::MakeConnString(TypConnSetting conn)
{
	char szbuf[256];
	_snprintf(szbuf, sizeof(szbuf), "%s|%d", conn.conn_host.c_str(), conn.conn_port);
	return std::string(szbuf);
}

void CScrSettings::ReadSettings()
{
	std::string strINIFile = GetINIFilename();
	if(strINIFile.length()) {
		FILE *fileINI = fopen(strINIFile.c_str(), "r");
		char line[2048];
		int nMatched;
		if(fileINI) {
			enum enum_section {SEC_NONE, SEC_CONNECTIONS, SEC_MACROS, SEC_OPTIONS} section = SEC_NONE;
			std::string strName, strValue;
			while(fgets(line, sizeof(line), fileINI)) {
				int len=strlen(line);
				if(len > 0 && '\n'==line[len-1]) {
					line[--len] = '\0';
				}
				if(!line[0]) continue;	// skip blank lines
				if('[' == line[0]) section = SEC_NONE;
				if(CScrUtil::StartsWithNoCase(line, "[Macros]", nMatched)) {
					section = SEC_MACROS;
					continue;
				} else if(CScrUtil::StartsWithNoCase(line, "[Connections]", nMatched)) {
					section = SEC_CONNECTIONS;
					continue;
				} else if(CScrUtil::StartsWithNoCase(line, "[Options]", nMatched)) {
					section = SEC_OPTIONS;
					continue;
				}
				BOOL bGotDelim = CScrUtil::ParseArg(line, '=', strName, strValue);
				if(SEC_MACROS == section) {
					if(bGotDelim) {
						strName = CScrUtil::StdStringToLower(strName);
						m_mapMacros[strName] = strValue;
					}
				} else if(SEC_CONNECTIONS == section) {
					if(0==stricmp("Default", strName.c_str())) {
						CrackConnString(strName, strValue, m_ConnDefault);
					}
				} else if(SEC_OPTIONS == section) {
					if(0==stricmp("FontFace", strName.c_str())) {
						m_strFontFace = strValue;
					} else if(0==stricmp("FontSize", strName.c_str())) {
						m_FontSizeInPoints = atoi(strValue.c_str());
					} else if(0==stricmp("NTextblocks", strName.c_str())) {
						m_nTextblocks = atoi(strValue.c_str());
						if(m_nTextblocks < 5) m_nTextblocks = 5;
						if(m_nTextblocks > BLK_NUMB) m_nTextblocks = BLK_NUMB;
					}
				}
			}
		}
	}
}

/*--- function GetMacroByName ---------------------
 *  Entry:	strName	is the name of a macro
 * 
 *  Exit:	Returns the value of the macro, or "" if not found.
 */
std::string CScrSettings::GetMacroByName(std::string strName)
{
	std::string strValue;
	strName = CScrUtil::StdStringToLower(strName);
	TypMapMacros::iterator iter = m_mapMacros.find(strName);
	if(iter != m_mapMacros.end()) {
		strValue = iter->second;
	}
	return strValue;
}

/*--- function GetDefaultConn ---------------------
 */
TypConnSetting CScrSettings::GetDefaultConn()
{
	return m_ConnDefault;
}

/*--- function SetDefaultConn ---------------------
 */
void CScrSettings::SetDefaultConn(TypConnSetting conn)
{
	m_ConnDefault = conn;
	std::string strValue = MakeConnString(conn);
	WritePrivateProfileString("Connections", "Default", strValue.c_str(), GetINIFilename().c_str());
}
