// ScrSettings.h: interface for the CScrSettings class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRSETTINGS_H__20BCE0E8_C4BB_4C76_9046_346A0C4BE926__INCLUDED_)
#define AFX_SCRSETTINGS_H__20BCE0E8_C4BB_4C76_9046_346A0C4BE926__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <map>

typedef struct struct_connection {
	std::string	conn_host;
	int			conn_port;
} TypConnSetting;

class CScrSettings  
{
	std::string m_strFontFace;
	int			m_FontSizeInPoints;
	int			m_nTextblocks;
	// TypMapMacros: key is lowercase version of macro name; value is macro string.
	typedef std::map<std::string, std::string> TypMapMacros;
	// TypMapConns: key is lowercase version of name; value is connection setting.
	//typedef std::map<std::string, TypConnSetting> TypMapConns;
	TypConnSetting	m_ConnDefault;
public:
	// m_mapMacros: index 
	TypMapMacros m_mapMacros;
public:
	CScrSettings();
	virtual ~CScrSettings();

	std::string GetINIFilename();
	void ReadSettings();
	const char *GetFontFace() {
		return m_strFontFace.c_str();
	}
	int GetFontSize() {
		return m_FontSizeInPoints;
	}
	int GetNTextblocks() {
		return m_nTextblocks;
	}
	std::string GetMacroByName(std::string strName);
	TypConnSetting GetDefaultConn();
	BOOL CrackConnString(std::string strName, std::string strValue, TypConnSetting &conn);
	std::string MakeConnString(TypConnSetting conn);
	void SetDefaultConn(TypConnSetting conn);

};

#endif // !defined(AFX_SCRSETTINGS_H__20BCE0E8_C4BB_4C76_9046_346A0C4BE926__INCLUDED_)
