// ScrUtil.cpp: implementation of the CScrUtil class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ScrUtil.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CScrUtil::CScrUtil()
{
	m_fileDebug = fopen("scredit2.log", "w");
   m_DbgLevel = 0;
}

CScrUtil::~CScrUtil()
{

}

void CScrUtil::DebugOut(const char *fmt,...) 
{
   if(m_DbgLevel > LL_NONE) {
      va_list argptr;
      char msg[12000];
      int nchars=0; //sprintf(msg, "%4.4x ", GetCurrentThreadId());

      va_start (argptr, fmt);
      nchars += _vsnprintf(msg+nchars, sizeof(msg)-2-nchars, fmt, argptr);
      va_end (argptr);
      msg[nchars] = '\n';
      msg[nchars+1] = '\0';
      if(m_fileDebug) {
         fputs(msg, m_fileDebug);
         fflush(m_fileDebug);
      } else {
         OutputDebugString(msg);
      }
   }
}

/*--- function StdStringToLower ---------------------
 *  Static function to return the lower-case version of the input string.
 */
std::string CScrUtil::StdStringToLower(std::string strIn)
{
	char *pszCopy = new char[strIn.length()+1];
	strcpy(pszCopy, strIn.c_str());
	strlwr(pszCopy);
	std::string strLower(pszCopy);
	delete []pszCopy;
	return strLower;
}

/*--- function StartsWithNoCase ---------------------
 *  Determine whether the beginning of szBuf matches szLookFor.
 *  This is a static function.
 *  Exit:	Returns TRUE if szBuf starts with szLookFor.
 *				nCharsMatched is the # of characters that matched.
 */
BOOL CScrUtil::StartsWithNoCase(const char *szbuf, const char *szLookFor, int &nCharsMatched)
{
	BOOL bMatches;
	nCharsMatched = 0;
	int len=strlen(szLookFor);
	bMatches = (0==strnicmp(szbuf, szLookFor, len));
	if(bMatches) {
		nCharsMatched = len;
	}
	return bMatches;
}

/*--- function ParseArg ---------------------
 *  Static function to parse a line of text of the form name delim value
 *  such as -p:23 or DefaultMacro=hithere
 *  Exit:	Returns TRUE if the delim was found in the line.
 *				strName	is the part of the string before delim.
 *				strValue	is the part of the string after the name.
 */
BOOL CScrUtil::ParseArg(const char *pszStr, char delim, std::string &strName, std::string &strValue)
{
	BOOL bGotDelim=FALSE;
   strName = "";
   strValue = "";
   const char *pDelim = strchr(pszStr, delim);
   if(pDelim) {
      strName = std::string(pszStr, pDelim-pszStr);
      strValue = 1+pDelim;
		bGotDelim = TRUE;
   } else {
      strName = pszStr;
   }
	return bGotDelim;
}

