# Sym2C.awk - Convert BLK.LENG  EQU      1024  to C #defines 
# Mark Riordan  2006-02-24
BEGIN {
	comment_out_col = 32
}

function PeriodsToUnderscores(intext) {
	gsub(/\./, "_", intext)
	return intext	
}

function trim(inline) {
	if(" "==substr(inline, length(inline), 1)) {
		inline = substr(inline, 1, length(inline)-1)
	}
	return inline
}

{
	if("SPACE" == $1) next;
	if(trim($0)=="") {
		print ""
		next
	}
	if("*" == substr($0,1,1)) {
		print "//" substr($0,3)
		next
	}
	line = $0
	comment = substr(line, 36)
	upper = toupper(line)
	if(upper ~ / EQU /) {
		varname = PeriodsToUnderscores(toupper($1))
		arg3 = PeriodsToUnderscores(toupper($3))
		if(substr(arg3, 1, 2)=="0#") {
			arg3 = "0x" substr(arg3,3)
		}
		out = "#define " varname " " arg3
	} else {
		out = " "
	}
	while(length(out) < comment_out_col) out = out " "
	out = out "// " comment
	print out
}