// TelnetC.cpp: implementation of the CTelnetC class, the telnet client.
//  This class processes the telnet protocol, encoding and decoding
//  bytes via an FSA.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TelnetC.h"
#include "ScrUtil.h"

extern CScrUtil ScrUtil;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTelnetC::CTelnetC()
{
   m_telstate = TELSTATE_DATA;
   m_subneg_type = 0;
}

CTelnetC::~CTelnetC()
{

}

int CTelnetC::sendbyte(unsigned char b1)
{
   return send(m_sock, (const char *)&b1, 1, 0);
}

int CTelnetC::sendbytes(unsigned char *bytes, int nbytes)
{
   return send(m_sock, (const char *)bytes, nbytes, 0);
}

int CTelnetC::sendbytes(unsigned char b1, unsigned char b2, unsigned char b3)
{
   unsigned char bytes[3];
   bytes[0] = b1;
   bytes[1] = b2;
   bytes[2] = b3;
   return sendbytes(bytes, 3);
}

void CTelnetC::send_ttype()
{
   // dw2 is the termcap entry for a DECwriter II, which I think is about
   // as close as we'll get to SCREDIT.  I thought it was la36, but I was wrong.
	// I decided to change to "dumb", because although scredit2 can deal with
	// 132-char lines, it isn't pretty.
   unsigned char aryTType[] = {0xFF, 0xFA, 0x18, 0x00, 'd', 'u', 'm', 'b', 0xFF, 0xF0};
   sendbytes(aryTType, sizeof(aryTType));
}

/*--- function CTelnetC::interpret_telnet ---------------------
 */
int CTelnetC::interpret_telnet(unsigned char *bufraw, int inbytes,
         unsigned char *bufout)
{
   int bytes_to_do = inbytes;
   int ibyte, bytes_out = 0;
   unsigned char rawb;
   //if(bufout.length < bytes_to_do) bytes_to_do = bufout.length;
   //System.out.print("Got " + Integer.toString(inbytes) + " bytes:");

   for(ibyte=0; ibyte<bytes_to_do; ibyte++) {
      rawb = bufraw[ibyte];
      //System.out.print(printable_byte(rawb) + " ");
      switch(m_telstate) {
         case TELSTATE_DATA:
            if(TELBYTE_IAC == rawb) {
               m_telstate = TELSTATE_IAC;
            } else {
               bufout[bytes_out++] = rawb;
            }
            break;
         case TELSTATE_IAC:
            switch(rawb) {
               case TELBYTE_WILL:
                  m_telstate = TELSTATE_WILL;
                  break;
               case TELBYTE_WONT:
                  m_telstate = TELSTATE_WONT;
                  break;
               case TELBYTE_DO:
                  m_telstate = TELSTATE_DO;
                  break;
               case TELBYTE_DONT:
                  m_telstate = TELSTATE_DONT;
                  break;
               case TELBYTE_SB:
                  m_telstate = TELSTATE_SB;
                  break;
            }
            break;
         case TELSTATE_WILL:
            m_telstate = TELSTATE_DATA;
            if(TELOPT_ECHO==rawb) {
               sendbytes(TELBYTE_IAC, TELBYTE_DO, rawb);
               sendbytes(TELBYTE_IAC, TELBYTE_DO, TELOPT_SGA);
            } else if(TELOPT_BINARY == rawb) {
               sendbytes(TELBYTE_IAC, TELBYTE_WILL, rawb);
               sendbytes(TELBYTE_IAC, TELBYTE_DO, rawb);
               sendbytes(TELBYTE_IAC, TELBYTE_WILL, TELOPT_TTYPE);
               //send_ttype();
            } else if(TELOPT_ENCRYPT == rawb) {
               sendbytes(TELBYTE_IAC, TELBYTE_DONT, rawb);
            } else {
               sendbytes(TELBYTE_IAC, TELBYTE_WONT, rawb);
            }
            break;
         case TELSTATE_WONT:
            m_telstate = TELSTATE_DATA;
            break;
         case TELSTATE_DO:
            m_telstate = TELSTATE_DATA;
            if(TELOPT_AUTH == rawb || TELOPT_ENVIR == rawb
                || TELOPT_NAWS == rawb) {
             sendbytes(TELBYTE_IAC, TELBYTE_WONT, rawb);
            } else if(TELOPT_BINARY == rawb) {
               sendbytes(TELBYTE_IAC, TELBYTE_WILL, rawb);
            } else if(TELOPT_TTYPE == rawb) {
               sendbytes(TELBYTE_IAC, TELBYTE_WILL, rawb);
            } else {
               sendbytes(TELBYTE_IAC, TELBYTE_WONT, rawb);
            }
            break;
         case TELSTATE_DONT:
            m_telstate = TELSTATE_DATA;
            break;
         case TELSTATE_SB:
            m_subneg_type = rawb;
            m_telstate = TELSTATE_SB_OPTION_TYPE;
            break;
         case TELSTATE_SB_OPTION_TYPE:
            m_telstate = TELSTATE_SB_OPTION_DATA;
            break;
         case TELSTATE_SB_OPTION_DATA:
            if(TELBYTE_SE == rawb) {
               m_telstate = TELSTATE_DATA;
               if(TELOPT_TTYPE == m_subneg_type) {
                  send_ttype();
               }
            }
            break;
     }
   }
   //System.out.println("");
   //System.out.println("Returning " + Integer.toString(bytes_out) + " bytes");
   return bytes_out;
}
