// TelnetC.h: interface for the CTelnetC class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TELNETC_H__B193F956_F08D_489C_AF4F_1053ECEFE4AA__INCLUDED_)
#define AFX_TELNETC_H__B193F956_F08D_489C_AF4F_1053ECEFE4AA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef enum enum_telstate {
 TELSTATE_DATA, TELSTATE_IAC, TELSTATE_WILL, TELSTATE_WONT,
 TELSTATE_DO, TELSTATE_DONT, TELSTATE_SB, TELSTATE_SB_OPTION_TYPE,
 TELSTATE_SB_OPTION_DATA
} TypTelstate;

#define TELBYTE_IAC 255
#define TELBYTE_WILL  251
#define TELBYTE_WONT  252
#define TELBYTE_DO    253
#define TELBYTE_DONT  254
#define TELBYTE_SB  250    // FA
#define TELBYTE_SE  240
#define TELOPT_BINARY 0
#define TELOPT_ECHO 1
#define TELOPT_SGA  3
#define TELOPT_TTYPE 24
#define TELOPT_NAWS 31
#define TELOPT_AUTH 37
#define TELOPT_ENCRYPT 38
#define TELOPT_ENVIR 39

class CTelnetC  
{
protected:
	TypTelstate m_telstate;
   unsigned char m_subneg_type;
public:
	SOCKET		m_sock;
protected:
   void send_ttype();
public:
	CTelnetC();
	virtual ~CTelnetC();

   int sendbyte(unsigned char b1);
	int sendbytes(unsigned char *bytes, int nbytes);
	int sendbytes(unsigned char b1, unsigned char b2, unsigned char b3);
	int interpret_telnet(unsigned char *bufraw, int inbytes, unsigned char *bufout);
};

#endif // !defined(AFX_TELNETC_H__B193F956_F08D_489C_AF4F_1053ECEFE4AA__INCLUDED_)
