// scredit2.cpp : Reimplementation of SCREDIT, a terminal emulator
//   and screen-scraping text editor for SCOPE/Hustler.
// The design of most of this program is based on the original SCREDIT,
// written by me at Michigan State University starting in 1980.
// Many of the comments and variables declarations in scredit2 were 
// mechanically translated from the original.  
// The executable statements in scredit2 were written by
// me by hand, based on the original design.
//
// Mark Riordan  25 December 2005
//
// This program source code and executable are released under the MIT X11 license.

#include "stdafx.h"
#include "resource.h"
#include "ScrApp.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst=0;	// current instance
HWND hWndMain=0;    // Handle to main window
TCHAR szTitle[MAX_LOADSTRING];			// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];
char *szAppName = "scredit2";
char szVersion[32];
CScrApp ScrApp;  // Main class
CScrUtil ScrUtil;

void GetVersion(char *pszVersion)
{
   void *verbuf;
   DWORD dwhandle;
   DWORD dwvers_size;
   unsigned int uValLen;
	char * pszSubBlock = "\\";
	pszVersion[0] = '\0';
   char filename[_MAX_PATH];
   GetModuleFileName(NULL,filename,_MAX_PATH);
   dwvers_size = GetFileVersionInfoSize(filename,&dwhandle);
   if(dwvers_size) {
      verbuf = malloc(dwvers_size);
      GetFileVersionInfo(filename,dwhandle,dwvers_size,verbuf);
      VS_FIXEDFILEINFO *pinfo;
      if(VerQueryValue(verbuf,pszSubBlock,(void **)&pinfo,&uValLen)) {
         wsprintf(pszVersion,"%d.%d.%d.%d",
            0xffff & (pinfo->dwFileVersionMS>>16),
            0xffff & pinfo->dwFileVersionMS,
            0xffff & (pinfo->dwFileVersionLS>>16),
            0xffff & pinfo->dwFileVersionLS);
      }
      if(verbuf) free(verbuf);
   }
}


//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{

   hInst = hInstance; // Store instance handle in our global variable

   hWndMain = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWndMain)
   {
      return FALSE;
   }

   ShowWindow(hWndMain, nCmdShow);
   UpdateWindow(hWndMain);

   return TRUE;
}

//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	char szmsg[1024], szmsg2[256];

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_ABOUT:
					wsprintf(szmsg,"%s -- Screen-scraping text editor and terminal emulator for SCOPE/Hustler.\r\nSee http://60bits.net  or  http://scredit2.sourceforge.net"
						"\r\n\r\nVersion %s, compiled %s %s"
						"\r\n\r\nWritten by Mark Riordan.  Freely available under MIT X11 license.",
						szAppName,szVersion,__DATE__,__TIME__);
					wsprintf(szmsg2,"About %s",szAppName);
					MessageBox(hWnd,szmsg,szmsg2,MB_OK);
				   break;
				case IDM_EXIT:
				   DestroyWindow(hWnd);
				   break;
				default:
				   return ScrApp.WndProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return ScrApp.WndProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_SCREDIT2);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= (LPCSTR)IDC_SCREDIT2;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);

	return RegisterClassEx(&wcex);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;
   WSADATA WSAData;
   if (WSAStartup(MAKEWORD(1, 1), &WSAData) != 0) {
		// Can't initialize WinSock--very unlikely.
      ScrUtil.DebugOut("Cannot initialize WinSock");
	}


	// Initialize global strings
	GetVersion(szVersion);
	strcpy(szWindowClass, "scredit2-class");
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	ScrApp.Initialize();
	ScrApp.SetCmdLine(lpCmdLine);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_SCREDIT2);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int)msg.wParam;
}
