// scrsyms.h - SCREDIT symbols
#ifndef SCRSYMS_INCLUDED
#define SCRSYMS_INCLUDED

// OS symbols
#define L_FNMAX MAX_PATH      // max # of chars in filename.

#define EXTRCHOK 1              // FLAG VALUE MEAnING EXTRA CHARS MAY
                                // follow COMMAND ABBREVIATION
#define NOEXTRCH 0              // FLAG VALUE MEAnING EXTRA CHARS MAY
                                // not FOLLOW COMMAND ABBREVIATION
#define UNIQUEAB 1              // FLAG VALUE FOR UNIQUE COMMAND
//                                 abbreviation
#define NOTUNIQA 0              // FLAG VALUE FOR NON-UNIQUE COMMAND
//                                 abbreviation.
//        SYMBOLS RELATING TO THE SCREEN AND LINES BEING DISPLAYED ON IT
#define SC_LNLEN 80             // LENGTH OF SCREEN LINES
#define SC_LNNUM 23             // NUMBER OF TEXT LINES ON SCREEN
#define SC_CLKPS 72             // WHEN THE CURSOR REACHES THIS CHAR
//                                 POSITION, SEVERAL CLICKS ARE SENT AS
//                                 AN END-OF-LINE WARNING TO THE USER.
#define SC_PHSCN 24             // # OF LINES ON PHYSICAL SCREEN
#define SC_TRSCN 23             // # OF LINES TO SCROLL WHEN 'PAGE'
//                                 HIT IN TERMINAL MODE.
#define SC_STATL 22             // SCREEN LINE # OF STATUS LINE.
#define SC_TABLN 7              // line # of screen (top=0) of tab line
//                                 in status mode.
#define SC_STLOR 22             // line ordinal of status line.

//        Line ordinals (0=top line of screen) pertaining to
//        the file transfer screen.

#define SC_FTNBY 4              // line ordinal for number of bytes
#define SC_FTRCP 5              // ordinal for host-requested pause
#define SC_FTSNP 6              // ordinal for scredit-requested pause
#define SC_FTWHC 2              // ordinal for sending or receiving
#define SC_FTNAM 2              // ordinal for file name
//        SYMBOLS RELATING TO LINES STORED IN THE MAIN LINE BUFFER
//                                 COUNTING FROM FIRST TEXT CHAR = 0
#define LN_BOILN -1             // FLAG IN BYTE 1 OF *BOI LINE
#define LN_EOILN -2             // BYTE COUNT FOR LAST LINE
#define LN_LENNO 6              // LENGTH OF LINE #
#define LN_TXLEN 140            // MAX # OF CHARS/LINE
#define LN_HDLEN 9              // LENGTH OF LINE HEADER
#define LN_MXLEN LN_TXLEN+LN_HDLEN// N MAX TOT LENGTH OF LINE
                                // 
//        other MASKS
#define MK_BLBGD 2              // BIT FOR 'FIRST LINE OF DEFINED BLOCK
//                                 HAS BEEN SET'
#define MK_BLEND 1              // BIT FOR 'LAST LINE OF DEFINED BLOCK
//                                 HAS BEEN SET'
#define MK_INEND 0xFF           // SIGNIFIES END OF BLOCK INDEX
#define MK_INBEG MK_INEND       // signifies beginning of block index
#define MK_BKEND 0xFF           // SIGNIFIEs END OF BLOCK
#define MK_ENDLS 0xFF           // BYTE USED TO TERMINATE A LIST,
//                                 PARTICULARILY THE LIST OF BLOCKS
//                                 THAT 'FREEBLK' SHOULD NOT REALLOCATE
#define MK_NOKYC 0xFF           // FLAG FOR 'NO KEYBOARD-ECHOED CHARS
//                                 ARE ON THIS LINE'.
#define MK_GOTKY 0x0F           // flag that, in fg.rkey & fg.kchr,
//                                 means we have a character.
#define MK_STBCM 0              // VALUE FOR FG.STAT:  MEANS IF WE'RE IN
//                                 STATUS MODE, WE'RE ON THE COMMAND
//                                 LINE, NOT DURING A COMMAND.
#define MK_STTAB 3              // VALUE FOR FG.STAT:  MEANS WE'RE IN
//                                 STATUS MODE, AND ON THE TAB LINE.
#define MK_STCIP 2              // VALUE FOR FG.STAT:  MEANS WE'RE IN
//                                 STATUS MODE, ON THE COMMAND LINE
//                                 WITH A COMMAND IN PROGRESS.
#define MK_BEGPK 0xFF           // Byte that marks the beginning of a
//                                 sequence of packed characters in
//                                 HELP-screen format.
#define V_FGFSE 1               // value for fg.fse to indicate fse
//                                 submode of vt200 mode.
#define V_FGVT2 0               // value for fg.fse to indicate vt220
//                                 submode of vt200 mode.
#define V_MFULL 2               // flag for 'fg.mful' to indicate
//                                 we ought to stop sending characters.
#define V_TONXCR 1              // flag for 'fg.mful' in indicate that
//                                 we can send characters only to the
//                                 next carriage return.
#define V_FTCPM 0xFF            // fg.fspm & fg.frpm flag value
//                                 indicating we ought to clear a
//                                 message on the file transfer display.
//        SPECIAL CHARACTER VALUES

#define AS_TAG 128              // VALUE TO ADD TO ASCII TO GET TAGGED
#define AS_ULDIF 0x20           // DIFFERENCE BETWEEN UPPER & LOWER CASE

//        SYMBOLS FOR COUNTS OF VARIOUS ITEMS (BYTES, ETC.)

#define CT_NFLBF 32             // IF WE ARE WITHIN THIS MANY CHARS
//                                 OF FILLING BUFFER, STOP FILLING IT.
#define CT_STIN2 16             // if we are still getting characters
//                                 when there are only this many free
//                                 spaces in the input buffer, send
//                                 another 'haltout'.
#define CT_MSGST 29             // NUMBER OF CHARS ON STATUS LINE
                                // MESSAGE AREA.
#define CT_PGLIN 21             // # OF LINES ON A PAGE
#define CT_NOKLN 24             // # OF LINES TO SEND BEFORE SENDING
//                                 'ready' to bring in 'editor'.
#define CT_MXCMC 40             // MAX # OF ALLOWABLE USER-TYPED CHAR
//                                 IN COMMAND MODE.
#define CT_MXREV 68             // MAX # OF CHARACTERS THAT CAN BE
//                                 reverse video'ed by the 'reverse
//                                 video' key.
#define CT_MNTRB 1              // default minimum # of textblocks
//                                 to allocate to terminal mode.
#define CT_MNEDB 1              // default minimum # of textblocks
//                                 to allocate to edit mode.
//                                 (actually, the minimum is zero, but
//                                 if we are grabbing textblocks away
//                                 from edit mode, we can't leave
//                                 fewer than this many blocks.)
#define CT_MNFTB 0              // MINIMUM NUMBER OF TEXT BLOCKS TO
//                                 ALLOCATE TO FILE TRANSFER MODE.
//                                 NONE ARE ALLOCATED BUT FILE TRANSFER
//                                 DOES REQUEST ONE.  IT IS TEMPORARILY
//                                 USED AS A DISK I/O BUFFER BUT IS
//                                 RETURNED AT THE END OF THE TRANSFER.
#define CT_MXBEH 120            // # of characters that can be stacked
//                                 up (unprocessed) in the input buffer
//                                 before we start ignoring requests
//                                 to display the screen in an attempt
//                                 to catch up.
#define CT_CTHUP 14             // maximum number of characters that
//                                 can be in the input buffer
//                                 (unprocessed) for scredit to still
//                                 consider itself caught up.
#define CT_LNVRT 2              // MAXIMUM NUMBER OF LINES WE CAN
//                                 display in one invocation of
//                                 'isrvrt'.
#define CT_VICBE 25             // # OF ENTRIES IN THE VIDEO BUFFER
//                                 (bf.vid, used to pass lines to
//                                 isrvrt).
#define CT_DFDND 8              // # OF LINES IN TERMINAL MODE THAT
//                                 we can suppress displaying (if we
//                                 get behind in processing characters)
//                                 before we've got to display the
//                                 screen anyway
#define CT_TIKBR 3              // NUMBER OF VERTICAL RETRACE INTERVALS
//                                 THAT A "BREAK" CONDITION SHOULD BE
//                                 HELD IN ORDER FOR THE MAINFRAME TO
//                                 BE ABLE TO DETECT IT.
#define CT_NLFWT 127            // number of timer ticks to wait before
//                                 deciding that something has wrong
//                                 with ct.lf (if it is still negative).
//                                 zero ct.lf if it is negative this
//                                 long.
#define CT_FTBYM 7              // number of digits in byte count
//                                 on file transfer screen.
#define CT_KYCLV 9              // number of unprocessed characters
//                                 in the bios keyboard buffer that
//                                 will signal to us that we are too
//                                 close to an overflow condition.
//                                 If we let characters pile up much
//                                 more than this, the bios would
//                                 start beeping the speaker, and
//                                 all hell would break loose.
#define CT_V2MAX 6              // maximum # of values that can
//                                 be sent in an esc sequence in
//                                 vt200 mode.
#define CT_GRFMX 2              // Maximum # of character sets in
//                                 vt200 mode.
//        Character set identifiers.
//        These are legal values for entries in grfcset--see the
//        comments for that array.

#define CS_ASCII 0              // ASCII character set
#define CS_GRAPH 1              // DEC special graphics character set
                                // 
//        SCREEN EDITOR PROGRAM MODES

//                 Program modes that are used to index into the
//                 character-subroutine tables must be assigned
//                 sequentially and in the same order in which the
//                 corresponding tables are entered in the
//                 character-table-pointer tables (TB.CREC and TB.CKEY)
//                 in ident 'TABLES'.
//                 This is because the program mode values are used
//                 to index into these two tables to find the correct
//                 character-subroutine table for each active mode.
#if 0
#define MD_FREE 0               // 0 means textblock is free.  there
//                                 is really no program mode that
//                                 has a value of zero.
#define MD_TRM 1                // TERMINAL MODE
#define MD_MSUE 2               // MSU EDITOR INTERFACE MODE
#define MD_CMD 3                // COMMAND MODE (FOR ALL MODES)
//                                 'command mode' is the mode in which
//                                 commands are being entered, either
//                                 as a part of status mode, or as a
//                                 part of edit mode.
#define MD_STA MD_CMD           // status mode
#define MD_HELP 5               // 'Help' mode.  Rather simple right
//                                 now, and not implemented for 8080's.
#define MD_FT 6                 // File transfer mode
#define MD_VT200 4              // vt200 emulation mode
#endif

//        other miscellaneous, unrelated modes.


//        md.v2hlxx symbols indicate which screen is to be
//        displayed, if we are in Help mode during vt200 emulation.

#define MD_V2HV2 0              // vt220 screen
#define MD_V2HFS 1              // fse screen
#define MD_V2HIB 2              // ibm 7171 screen
#define MD_V2HMX 2              // maximum value

//
//                 Symbols relating to file transfer modes and steps
//
#define FT_CLER 0               // No file transfer operation happening
#define FT_SEND 1               // FT - SEND a file to the asynch port
#define FT_RECV 2               // FT - RECEIVE a file from asynch port
#define FT_FLUSH 2              // Flush Multiple byte send
#define FT_BIT6 0x40            // Used to manipulate bit 6 for
//                                 decoding SCREDIT protocol data
#define FT_BIT7 0x80            // Used to manipulate bit 7 for
//                                 decoding SCREDIT protocol data
#define MAX_DUP 255             // Maximum dup chars per each count
//

//                 Flag values to use with extended ESCAPE sequence
//                 sense modifier flags.
//
#define FGV_NEG 0x80            //      Flag value for negate
#define L_ESCTB '~'-'0'+1 //      Length of extended ESCAPE table
//
//                 Symbols used with disk accessing routines
//
#define RDOK 0                  // Read was ok and returned data
#define RDEOF 1                 // Read failed because out of data
#define RDERROR 2               // Read failed because of error
//
#define WROK 0                  // Write was OK
#define WRERROR 2               // Write failed because of error
//
#define FILOK 0                 // File action was OK
#define FILERR 2                // Error in file action
//        OFFSET SYMBOLS (FOR ADDRESSES RELATIVE TO OTHER ADDRESSES, ETC

//        offsets that relate to the structure of the command table.

#define OF_CMLEN 0              // OFFSET FROM BEG OF COMMAND FOR
                                // COMMAND LENGTH BYTE
#define OF_CUNAF 1              // OFFSET FROM BEG OF COMMAND FOR
                                // UNIQUE ABBREVIATION FLAG BYTE
#define OF_CEXCF 2              // OFFSET FROM BEG OF COMMAND FOR
                                // 'EXTRA CHARS MAY FOLLOW' BYTE
#define OF_CABCH 3              // OFFSET FROM BEG OF COMMAND TO
                                // THE ABBREVIATION CHARS
                                // 
#define OF_CMDIS 1              // OFFSET FROM BEG OF STATUS LINE
                                // TO COMMAND DISPLAY AREA
#define OF_MSGST 24             // OFFSET FROM BEG OF STATUS LINE TO
                                // MESSAGE DISPLAY AREA.

#define OF_LNLEN 6              // OFFSET FROM BEG OF LINE FOR LENG BYTE
//                                 in internal packed textline.
#define OF_LNFKC 7              // offset from beg of line for ordinal
//                                 of first keyboard char.
//                                 (in internal packed textline.)

#define OF_INBKN 6              // OFFSET FROM BEG OF INDEX ENTRY FOR
//                                 textblock number BYTE
#define OF_INNLN 7              // OFFSET FROM BEG OF INDEX ENTRY FOR
//                                 # OF LINES IN BLOCK
#define OF_INBNO 0              // OFFSET FROM BEG OF INDEX ENTRY FOR
//                                 LINE # OF FIRST LINE IN BLOCK.

#define OF_LDMSG 8              // offset from the beginning of the
//                                 line containing the 'loading'
//                                 message (in downline loading)
//                                 to get to the ascii form of the
//                                 current load address.
#define OF_DBSUB 73             // offset from beg of debug line to
//                                 place to put the subroutine name.
#define OF_CMDSC 16             // offset from beg of screen line
//                                 to display 'baud' & other cmnds
//                                 in status mode.
                                // 
#define OF_FGSTY 0              // offset from beg of flag line for
//                                 "Stay" message.
#define OF_FGCRL OF_FGSTY+6     // offset from beg of flag line for
//                                 "CR Disable" message.
#define OF_FGWDP OF_FGCRL+12    // offset from beg of flag line for
//                                 "Word Proc" message.
#define OF_FGVER OF_FGWDP+11    // offset from beg of flag line for
//                                 "Verify" message.
#define OF_FGNUM OF_FGVER+8     // offset from beg of flag line for
//                                 "Num Lock" message.
#define OF_FGSCL OF_FGNUM+10    // offset from beg of flag line for
//                                 "Scroll" message.
#define OF_FGCAP OF_FGSCL+8     // offset from beg of flag line for
//                                 "upper case" message.
#define OF_FGINS OF_FGCAP+12    // offset from beg of flag line for
//                                 "Insert" message.
#define OF_FGPRS OF_FGINS+8     // OFFSET FROM BEG OF FLAG LINE FOR
//                                 "PRTSC" MESSAGE.
#define OF_FGFSE 29             // offset from beg of flag line for
//                                 "fse" message, vt200 mode.
#define OF_FGCEN OF_FGCRL       // offset from beg of flag line for
//                                 'cr enter' mode indicator.

//        Offsets from the beginning of the line for messages
//        on the file transfer screen.

#define OF_FTNBY 25             // lwa of byte count (decimal)
#define OF_FTRCP 52             // fwa of 'host-requested pause'
#define OF_FTSNP 52             // fwa of 'scredit-requested pause'
#define OF_FTWHC 7              // 'sending' or 'receiving'
#define OF_FTNAM 19             // file name.
                                // 

//        Symbols to describe a certain type of circular buffer.
//        These circular buffers look like this:
//
//        ------------------------------------------------------------
//        I  -IN-   I  -Out-  I Num of  I  Entry  I  Actual data
//        I         I         I Entries I  Size   I  Buffer
//        ------------------------------------------------------------
//          1 byte     1 byte    1 byte   1 byte  ^  # of bytes=
//                                                I    (Num of entries)
//      address by which this structure is known--^     * (Entry Size)

#define C_CBFIN -4              // offset from buffer to -in- pointer
//                                 which is relative to buffer address
//                                 and is expressed in entry ordinals.
#define C_CBFOUT -3             // offset from buffer to -out- pointer
//                                 which is relative to buffer address
//                                 and is expressed in entry ordinals.
#define C_CBFNEN -2             // offset from buffer to number of
//                                 entries byte.  This is not the
//                                 current number of active entries,
//                                 but rather the (static) size of
//                                 the buffer.
#define C_CBFESZ -1             // offset from buffer to byte with
//                                 entry size in bytes.
//        SYMBOLS RELATING TO COMMANDS & COMMAND MODE
//
//        The symbols for most commands are assigned in chronological
//        order of implementation--that is to say, the values of
//        the symbols have no special significance.
//        however, the symbols for the "baud" commands have
//        as their values the baud rate bits for the asynchronous
//        adapter.  these symbols can range in value from 0 to 15,
//        and correspond to bits 3-0 of the "com1" command to the
//        adapter hardware.
//        this rather crude approach was taken to save valuable
//        memory in the implementation of the baud commands.
//        some available baud rates (such as 75) just aren't
//        very useful, so they aren't included here.  this
//        is why there are a few holes in the table in the
//        range 0-15.
//        (the hex values for the baud symbols signify their
//        special significance.)

#define CMP_EOA 0               // FLAG FOR END OF ABBREVIATION
#define CMP_EOT 0               // FLAG FOR END OF COMMAND TEXT

#define CM_BA11 0x02            // FLAG FOR COMMAND=BAUD 110
#define CM_BA30 0x05            // FLAG FOR COMMAND=BAUD 300
#define CM_BA60 0x06            // FLAG FOR COMMAND=BAUD 600
#define CM_BA120 0x07           // FLAG FOR COMMAND=BAUD 1200
#define CM_BA180 0x08           // FLAG FOR COMMAND=BAUD 1800
#define CM_BA200 0x09           // FLAG FOR COMMAND=BAUD 2000
#define CM_BA240 0x0A           // FLAG FOR COMMAND=BAUD 2400
#define CM_BA360 0x0B           // FLAG FOR COMMAND=BAUD 3600
#define CM_BA480 0x0C           // FLAG FOR COMMAND=BAUD 4800
#define CM_BA720 0x0D           // FLAG FOR COMMAND=BAUD 7200
#define CM_BA960 0x0E           // FLAG FOR COMMAND=BAUD 9600
#define CM_BA192 0x0F           // FLAG FOR COMMAND=BAUD 19200

#define CM_EDIT 16              // EDIT COMMAND
#define CM_XDOT 17              // X. COMMAND
#define CM_DEBUG 18             // DEBUG COMMAND
#define CM_OFFCK 19             // TURN OFF KEYBOARD CLICKS
#define CM_ONCK 20              // TURN ON KEYBOARD CLICKS
#define CM_INIT 21              // REINITIALIZE THE SYSTEM
#define CM_TAB 22               // SET TAB STOPS
#define CM_OFFRV 23             // OFF REVERSE VIDEO
#define CM_ONRV 24              // ON REVERSE VIDEO
#define CM_SRLPT 25             // select serial port
#define CM_OFFKP 26             // OFF KEYPUNCH
#define CM_ONKP 27              // ON KEYPUNCH
#define CM_RSTTB 28             // reset tabs
#define CM_FTMOD 29             // Go to file transfer mode
//

//        NOTE:  YOU MUST SET  CMP.NCMX TO THE NUMBER OF COMMANDS
//              THAT ARE DEFINED EACH TIME YOU ADD A COMMAND.

#define CMP_NCMX 29             //  MAXIMUM NUMBER OF COMMANDS

//        SYMBOLS RELATED TO THE TEXTBLOCK INDEX.

#define IDX_NENT 252           // MAX # OF ENTRIES IN INDEX
#define IDX_ENTR 8    // # OF BYTES IN INDEX ENTRY // was 10 in SCREDIT

//        SYMBOLS RELATED TO TEXTBLOCKS

#define BLK_LENG 1024           // LENGTH OF TEXTBLOCK
#define BLK_HALF 720            // PLACE TO SPLIT TEXTBLOCK
#define BLK_NUMB (IDX_NENT-2)   // MAX NUMBER OF TEXTBLOCKS IN CM
#define BLK_OFFSET_ACTIVE_BYTES 0   // Offset from beg of textblock for count of active bytes.
#define BLK_HEAD 2              // LENGTH OF TEXTBLOCK HEADER
#define BLK_TEXT BLK_LENG-BLK_HEAD  // # OF BYTES IN BLOCK AVAILABLE
//                                    FOR TEXT.

//        SYMBOLS USED IN DISPLAYING DEBUG/STATUS INFORMATION

#define D_COLUMN 77             // COLUMN # DISPLAY LOC ON STATUS LINE
#define D_LINENO 59             // LINE # DISPLAY LOC ON STATUS LINE
#define D_LINMSG 54             // 'LINE=' MESSAGE LOC ON STATUS LINE
#define D_CLOCK 0               // PLACE ON DEBUG LINE FOR CLOCK
#define D_TABSET 49             // offset from beg of status line
//                                 for tabset currently in use.
#define D_VERIFY 47             // offset from beg of status line
//                                 for flag indicating whether we are
//                                 in VERIFY mode.
#endif
